function [vout, x] = pbrsolve (par)
    vtotal = par.vfinal*linspace(0,1,par.nvs)';
    vsteps = vtotal;
    x0=par.Nafin;

    opts = odeset ('Events', @(t,x) stop (t,x,par), 'AbsTol', sqrt (eps), 'RelTol', sqrt (eps));
    [vout, x] = ode15s (@(t,x) pbr (t,x,par), vsteps, x0, opts);

    if ( numel(vout) == par.nvs )
        fprintf ('hey, did not reach final conversion, increase stopping time\n');
    end%if
end%function

function xdot = pbr (t, x, par)
    Na = x(1);
    ca = par.P/(par.Rg*par.T) * Na/(2*par.Nafin);
    Phi = par.Rp/3*sqrt((par.n+1)/2*par.k*ca/par.Da);
    xdot = -par.rhob/par.rhop*par.eta(Phi)*par.k*ca^par.n;
end%function

function [retval, isterminal, direction] = stop(t, x, par)
    Na = x(1);
    retval = Na - (1-par.xa)*par.Nafin;
    isterminal = 1;
    direction = 0;
end%function
