function book_setup(ifmissing)
% book_setup()
% book_setup('warn')
% book_setup('error')
% book_setup('ignore')
%
% Adds the necessary directories to Octave/Matlab's path and checks for
% Casadi and MPCTools. Argument specifies what to do if Casadi/MPCTools are not
% found.
narginchk(0, 1);
if nargin() < 1
    ifmissing = 'warn';
end

% Add the booklib path.
thisdir = fileparts(mfilename('fullpath'));
addpath([thisdir, '/booklib']);

% Load packages.
if isOctave()
  pkg('load', 'optim', 'statistics');
end%if

% Add the booklib path again; avoid bug in the optim fmincon package.
thisdir = fileparts(mfilename('fullpath'));
addpath([thisdir, '/booklib']);


% Bug in dasrt octave version 4.2.1
if isOctave() && isequal(version(), '4.2.1')
    warning(['The function dasrt is bugged in Octave 4.2.1. ', ...
             'Scripts calling dasrt may fail.']);
end

% Look for local Casadi folder, adding to path if found.
directories = {'casadi'};
for i = 1:length(directories)
    directory = [thisdir, '/', directories{i}];
    if exist(directory, 'dir')
        addpath(directory);
    end
end

% Issue errors, warnings, etc.
switch ifmissing
case 'error'
    missing = @error;
case 'warn'
    missing = @warning;
case 'ignore'
    missing = @(varargin) [];
otherwise
    error('Invalid argument!');
end

if isempty(which('casadiMEX'))
    missing(['Casadi not found. Download from `casadi.org` and unzip ' ...
             'to a folder called ''casadi''.']);
end

end%function

