function [t_out, x] = ode15i (f, t, x0, xdot0, options)

  if (nargin == 4 || nargin == 5)

    global __ode15i_res_fcn__;
    global __ode15i_event_fcn__;

    __ode15i_res_fcn__ = f;

    use_dasrt = false;
    if (nargin == 5)
      if (isfield (options, "Events") && ! isempty (options.Events))
	use_dasrt = true;
	__ode15i_event_fcn__ = options.Events;
	options_fcn = @dasrt_options;
      else
	options_fcn = @dassl_options;
      endif
      if (isfield (options, "RelTol") && ! isempty (options.RelTol))
	options_fcn ("relative tolerance", options.RelTol)
      endif
      if (isfield (options, "AbsTol") && ! isempty (options.AbsTol))
	options_fcn ("absolute tolerance", options.AbsTol)
      endif
      if (isfield(options, "MaxStep") && ! isempty (options.MaxStep))
    options_fcn("step limit", options.MaxStep)
      endif
    endif

    if (use_dasrt)
      [x, xdot, t_out] = dasrt ("__dasrt_res__", "__dasrt_event_fcn__",
				x0, xdot0, t);
    else
      x = dassl ("__dassl_res__", x0, xdot0, t);
      t_out = t;
    endif

  else
    usage ("[t_out, x] = ode15i (f, t, x0, options)");
  endif

endfunction

% ----------------------------------------------------------------------

function res = __dassl_res__ (x, xdot, t)

  global __ode15i_res_fcn__;

  res = __ode15i_res_fcn__ (t, x, xdot);

endfunction

% ----------------------------------------------------------------------

function resid = __dasrt_res__ (x, xdot, t)

  global __ode15i_res_fcn__;

  resid = __ode15i_res_fcn__ (t, x, xdot);

endfunction

% ----------------------------------------------------------------------

function retval = __dasrt_event_fcn__ (x, t)

  global __ode15i_event_fcn__;

  %% warning: the xdot argument is not used by dasrt;  supplying zeros;
  xdot = zeros(size(x));
  retval = __ode15i_event_fcn__ (t, x, xdot);

endfunction
