%%
%% Revised 8/16/2018

tfin = 1;
lambda = 10000;
nsim = tfin*lambda;

igrid = 1:nsim;
nts = 5;
p = zeros(nsim,nts);
tvec = linspace(0.1,0.9,nts);

for i = 1:nts
    tau = tfin*tvec(i);
    logp = -lambda*tau +  (igrid-1)*log(lambda*tau) - gammaln(igrid);
    pbig(:,i) = exp(logp);
endfor

igridbig = igrid;

lambda = 100;
nsim = tfin*lambda;

igrid = 1:nsim;
nts = 5;
p = zeros(nsim,nts);
tvec = linspace(0.1,0.9,nts);

for i = 1:nts
    tau = tfin*tvec(i);
    logp = -lambda*tau +  (igrid-1)*log(lambda*tau) - gammaln(igrid);
    psmall(:,i) = exp(logp);
endfor

igridsmall = igrid;
table1 = [igridsmall', psmall];
table2 = [igridbig', pbig];
save "singleparticle.dat" table1 table2

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    subplot(2,1,1)
    plot(table1(:,1), table1(:,2:6))

    subplot(2,1,2)
    plot(table2(:,1), table2(:,2:6))
    %% TITLE
endif %% PLOTTING