%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%% Revised 7/24/2018

%
% rate_estimation.m
%
stoi = [0 1 0 -1 -1 1; -1 1 1 -1 0 0; 1 0 -1 0 -1 1];
r = [1;2];
A = stoi(1:2,:);
R = A'*r;
%
% set seed for "reproducible" random numbers
%
randn('seed',1)
%
%just a few noisy points
%
npoints = 6;
Rmeas = zeros (6, npoints);

for i = 1:npoints
    Rmeas(:,i) = 0.05*randn(6,1) + R;
endfor

rest = (inv(A*A')*A * Rmeas)';
%%save_precision(5);
%%save rate_estimation.dat rest;
myfile = fopen("rate_estimation.dat", 'w');
fprintf(myfile, '%8.4f %8.4f \n', rest')
fclose(myfile);

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (rest(:,1), rest(:,2), '+');
    axis ([.8, 1.2, 1.8, 2.2]);
    %% TITLE
endif %% PLOTTING