%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%% Revised 7/24/2018

ac = 1.4;
ca = 2.0;
pa0 = 0.65;
pc0 = 0.5;

npts = 100;
x = linspace(0,1,npts)';

pa = pa0*x.*exp((1-x).*(1-x).*(ac+2*(ca-ac)*x));
pc = pc0*(1-x).*exp((x.*x).*(ca+2*(ac-ca)*(1-x)));
ptot = pa + pc;
paid = pa0*x;
pcid = pc0*(1-x);
ptotid = paid + pcid;

table = [x pa pc ptot paid pcid ptotid];
save -ascii margules.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (x, [pa, pc, ptot, paid, pcid, ptotid]);
    %% TITLE
endif %% PLOTTING