%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

% This script file solves the multimedia example STR_CSTR
% that illustrates how a STR approaches the steady state and
% becomes a CSTR at sufficiently long time.
% It was developed February 1999, last edited February 8, 1999.
%
% This program is modified here for an example to be inserted into the text
% Last edited by Ekerdt on June 15, 2001

%% Revised 7/24/2018

p = struct();
p.caf = 2;    %gmoles/liter
%cao = input('Enter the initial concentration of A in gmole/liter.   ');
%k = input('Enter the rate constant in min^{-1}.                   ');
%theta = input('Enter the reactor residence time in min.               ');
%tf = input('Enter the integration time in min.                     ');
%set the default values at cao = 0, k = 0.1, theta = 100, tf = 120
%disp('The steady state reactor concentration of A in gmole/liter is ')

p.cao = 0;
p.k = 0.1;
p.theta = 100;
tf = 120;

c_ss = p.caf/(1 + p.k*p.theta);

function dcdt = mat_bal(t,x,p)
    ca = x(1);
    dcdt(1) = (1/p.theta)*(p.caf - ca) - p.k*ca;
endfunction

t = [0:.1:tf]';
c_o = [p.cao];
tff = (10*tf)+1;

opts = odeset ('AbsTol', sqrt (eps), 'RelTol', sqrt (eps));
[tsolver, solution] = ode15s (@(t,x) mat_bal(t,x,p), t, c_o, opts);
answer = [t solution c_ss*ones(tff,1)];

p.cao = 2.0;
c_o = [p.cao];

opts = odeset ('AbsTol', sqrt (eps), 'RelTol', sqrt (eps));
[tsolver, solution1] = ode15s (@(t,x) mat_bal(t,x,p), t, c_o, opts);
answer1 = [t solution1 c_ss*ones(tff,1)];

answer = [answer solution1];
save -ascii strcstr.dat answer;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (answer(:,1), answer(:,[2,4,3]));
    %% TITLE
endif %% PLOTTING