%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%%
%% add a stochastic simulation using Gillespie's algorithm
%% jbr, 5/23/00
%%
%% Revised 7/24/2018
%%
%% example 1: A + B  --> C
%%            C      --> A + B
%%
% k(1) = 1;
% k(2) = 1/2;
% stoi = [-1 -1 1; 1 1 -1];
% [nrxs,nspec]=size(stoi);
% clear x
% x(1,1)= 1000;
% x(2,1)= 900;
% x(3,1)= 0;
%%
%% example 2: A --> B
%%            B --> C


k(1) = 2;
k(2) = 1;
stoi = [-1 1 0; 0 -1 1];
[nrxs,nspec] = size(stoi);
nsim = 200;
time = zeros (nsim+1, 1);
x = zeros (3, nsim+1);
x(1,1) = 100;
x(2,1) = 0;
x(3,1) = 0;

%%
stoiT = stoi';
time(1) = 0;
rand('seed', 0);

for n = 1:nsim
    r(1) = k(1)*x(1,n);
    r(2) = k(2)*x(2,n);
    rtot = sum(r);
    p = rand(2,1);
    tau = -log(p(1))/rtot;
    time(n+1) = time(n)+tau;

    %% determine which reaction (mth) is likely to occur
    m = sum (cumsum (r) <= p(2)*rtot) + 1;
    x(:,n+1) = x(:,n) + stoiT(:,m);
endfor

[ts,xs] = stairs(time, x');
table = [ts(:,1), xs];
save -ascii stoch_small.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (table(:,1),table(:,2:4));
    axis ([0, 5, 0, 100]);
    %% TITLE
endif %% PLOTTING