%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%%
%% Hepatitis B model, stochastic simulation

% This m-file loads data file 'hbv_binary.mat'.
% Compile .oct file from 'stochsim.cc'.
if exist('stochsim') ~= 3
    mkoctfile('-v', 'stochsim.cc');
end

[p, tsolver, x] = hbv_common();

%%
%% already ran simulation, just load file and write a plotting file
%%

load hbv_binary.mat;

%%
%% save for plotting
%%
%% nullseed(121) generates a nice figure
%%
rand('seed', nullseed(121))
xnull = stochsim(p.x0, p.k, p.stoiT, p.tout);

table = [p.tout, x, xavg', xout', xnull'];
save -ascii hbv_stoch_env.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
plot (table(:,1),[table(:,4),table(:,7)]);
axis ([0,200,0,10000]);
%% TITLE
endif %% PLOTTING