
%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%% Hepatitis B model, stochastic simulation.  Data and functions defined
%% in this file are used in all the hbv_stoch.m and hbv_binary.m

function [p, tsolver, x] = hbv_common()

k = [1; 0.025; 1000; 0.25; 2; 7.5e-6];
p.k = k;
stoi = [0, 1, 0; 1, -1, 0;
        0, 0, 1; -1, 0, 0;
        0, 0, -1; 0, -1, -1];
x0  = [1; 0; 0];
stoiT = stoi';
tfin  = 200;
nts   = 200;
tout = linspace(0,tfin,nts)';

p.x0 = x0; p.k = k; p.stoiT = stoiT; p.tout = tout; p.tfin = tfin;
p.nts = nts;

%% steady state analysis
cas = ( k(1)-k(4) ) /   ...
      ( k(6) *k(4)/k(2)*( (-k(1)+k(4) +k(3)) / (k(5))) );
cbs = k(4)/k(2)* cas;
ccs = ( k(1)-k(4) ) / ( k(6) *k(4)/k(2) );
Jac = [-k(4), k(2), 0;
        k(1), -k(2)-k(6)*ccs, -k(6)*cbs;
        k(3), -k(6)*ccs, -k(5)-k(6)*cbs];
eig(Jac);

## function rhs = hbv_deriv(t, x, p);
##   rhs = [p.k(2)*x(2) - p.k(4)*x(1);
## 	 p.k(1)*x(1) - p.k(2)*x(2) - p.k(6)*x(2)*x(3);
## 	 p.k(3)*x(1) - p.k(5)*x(3) - p.k(6)*x(2)*x(3)];
## end%function


%% deterministic dynamics
opts = odeset ('AbsTol', sqrt (eps), 'RelTol', sqrt (eps));
[tsolver, x] = ode15s(@(t,x) hbv_deriv(t,x,p), tout, x0, opts);

%% Although stochsim is a .cc file for speed,
%% list the function here as an m file so it's easier to
%% read what it's doing.

%function xout = stochsim(x0, k, stoiT, tout)
%    nts  = length(tout);
%    tfin = tout(nts);
%    time = tout(1);
%    x = x0;
%    iout = 1;

%    while (time < tfin)
%        r(1) = k(1)*x(1);
%        r(2) = k(2)*x(2);
%        r(3) = k(3)*x(1);
%        r(4) = k(4)*x(1);
%        r(5) = k(5)*x(3);
%        r(6) = k(6)*x(2)*x(3);
%        rtot = sum(r);

%        p=rand(2,1);
%        % choose likely time of next reaction
%        tau = -log(p(1))/rtot;
%        timenew = time + tau;
%        % choose which reaction (mth) is likely to occur
%        rcum = 0;
%        m = 0;

%        while ( rcum <= p(2)*rtot)
%            m = m + 1;
%            rcum = rcum + r(m);
%        endwhile

%        xnew  = x + stoiT(:,m);
%        % check if passing time of requested output

%        while ( tout(iout) <= timenew )
%            xout(:,iout) = x;
%            iout = iout + 1;

%            if (iout > nts)
%                break;
%            endif
%        endwhile

%        time = timenew;
%        x = xnew;
%    endwhile
%endfunction

%xplot1 = stochsim(x0, k, stoiT, tout);

end%function