%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 7/24/2018

D = 109.5;
B = 1.94;
re = .742;
r = [0:.01:5]';
V = D*(exp(-2*B*(r-re)) - 2*exp(-B*(r-re)));
temp = [r V];

D = 140.5;
B = 2.22;
re = .917;
V = D*(exp(-2*B*(r-re)) - 2*exp(-B*(r-re)));
temp = [temp V];

save -ascii morse.dat temp;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot(temp(:,1), temp(:,2:3));
    axis ([0, 5, -150, 200]);
    %% TITLE
endif %% PLOTTING