%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

% This program "schm1_conc.m" generates curves for the final product in
% a series problem as the rate constant ratios for the first and
% second first-order reactions are varied.
% Last edited 1/30/97.
%%
%% Revised 7/24/2018

p = struct(); % Create structure to pass parameters to ode15s function
p.k1 = 1.0;

function dcdt = rxrate(t,x,p)
    c1 = x(1);
    c2 = x(2);
    c3 = x(3);

    r1 = p.k1*c1;
    r2 = p.k2*c2;

    dcdt = [-r1; r1-r2; r2];
endfunction

p.k2 = 1.0;
Initial = [1,0,0]';
t = [0:.01:5]';
opts = odeset ('AbsTol', sqrt (eps), 'RelTol', sqrt (eps));
[tsolver, solution] = ode15s(@(t,x) rxrate(t,x,p),t,Initial,opts);
answer = [t solution];

p.k2 = 10.0;
[tsolver, solution] = ode15s(@(t,x) rxrate(t,x,p),t,Initial,opts);
answer = [answer solution];

p.k2 = 50.0;
[tsolver, solution] = ode15s(@(t,x) rxrate(t,x,p),t,Initial,opts);
answer = [answer solution];

c_Css = 1 - exp(-p.k1*t); %solution for k2 = Inf
answer = [answer c_Css];

save -ascii schm1_conc.dat answer;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (answer(:,1),[answer(:,4),answer(:,7), ...
          answer(:,10),answer(:,11)]);
    %% TITLE
endif %% PLOTTING