%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 7/24/2018

%
%  This is an m-file for generating the form of an adsorption curve
%

P=(0:250)';
answer = P;
CO_s1 = (0.01*P)./(1 + 0.01*P);

answer = [answer CO_s1];

for K=1:1:100;
    CO_s = (0.1*K*P)./(1 + 0.1*K*P);
    answer = [answer CO_s];
endfor

save -ascii isotherm_general.dat answer;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (answer(:,1),[answer(:,2:3),answer(:,12),answer(:,102)]);
    axis ([-5,250,0,1.05]);
    %% TITLE
endif %% PLOTTING