%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

% assoc_isotherm.m ;   fit to nonlinear form of isotherm
% jbr, 2/23/98
%
% Revised 8/22/2018

% Pdata = load ('assoc_isotherm.rdat');
Pdata = [100, 1.28;
         150, 1.63;
         200, 1.77;
         250, 1.94;
         300, 2.06;
         400, 2.21];

ndata = size(Pdata,1);
ngrid = 20;
P = Pdata(:,1);

b = 1e6/(760*82.06*373);
CO = b*P;
CO_s = Pdata(:,2);
data = [CO CO_s];
%save -ascii assoc_isotherm.xdat data;

%
% Find the best K_CO and c_m values for the isotherm
%
function sqerror = f(x, CO, CO_s)
    K_CO = x(1);
    c_m = x(2);
    CO_sc =  (c_m*K_CO*CO)./(1 + K_CO*CO);
    diff = CO_s - CO_sc;
    sqerror = diff'*diff;
endfunction

optimset ('TolFun', 1e-12);
guess = [10; 1];
[x, obj, info] = fminunc(@(x) f(x, CO, CO_s), guess);
info;
K_CO = x(1);
c_m = x(2);

CO_grid = linspace(CO(1), CO(ndata), ngrid)';
CO_s_opt = (K_CO*c_m*CO_grid)./(1 + K_CO*CO_grid);

output = [CO_grid CO_s_opt];
%save -ascii assoc_isotherm.fit output;
save assoc_isotherm.dat output data

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (output(:,1),output(:,2),data(:,1),data(:,2),'o');
    axis ([3.8,18,1,2.4]);
    %% TITLE
endif %% PLOTTING