%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 8/22/2018

function retval = Vau(r1, r2, p)
    r3 = r1 + r2;
    r(1) = r1;
    r(2) = r2;
    r(3) = r3;

    for x = 1:3
        E1(x) = p.D1(x)*(exp(-2*p.B1(x)*(r(x) - p.r10(x))) - ...
                    2*exp(-p.B1(x)*(r(x) - p.r10(x))));
        E3(x,1) = p.D3(x)*(exp(-2*p.B3(x)*(r(x) - p.r30(x))) + ...
                    2*exp(-p.B3(x)*(r(x) - p.r30(x))));
        E3(x,2) = p.C(x)*(r(x) + p.A(x))*exp(-p.Si(x)*r(x));

        if (r(x) <= p.R_1(x))
            y = 1;
        else
            y = 2;
        endif

    Q(x) = (E1(x) + E3(x,y))/2;
    J(x) = (E1(x) - E3(x,y))/2;

    endfor
    retval = Q(1) + Q(2) + Q(3) - sqrt(0.5*((J(1) - J(2))*(J(1) - J(2)) + ...
                (J(2) - J(3))*(J(2) - J(3))+(J(1) - J(3))*(J(1) - J(3))));
endfunction