%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 8/22/2018

function retval = lder(r2, r1, p)
    r3 = r1 + r2;
    r(1) = r1;
    r(2) = r2;
    r(3) = r3;

    for x = 1:3
        E1(x) = p.D1(x)*(exp(-2*p.B1(x)*(r(x) - p.r10(x))) - ...
                    2*exp(-p.B1(x)*(r(x) - p.r10(x))));
        E3(x,1) = p.D3(x)*(exp(-2*p.B3(x)*(r(x) - p.r30(x))) + ...
                    2*exp(-p.B3(x)*(r(x) - p.r30(x))));
        E3(x,2) = p.C(x)*(r(x) + p.A(x))*exp(-p.Si(x)*r(x));

        if (r(x) <= p.R_1(x))
            y = 1;
        else
            y = 2;
        endif

        Q(x) = (E1(x) + E3(x,y))/2;
        J(x) = (E1(x) - E3(x,y))/2;
    endfor

    %dQ(a,b) means dQ(a)/dr(b)
    for i = 1:3
        dE1(i,i) = -2*p.B1(i)*p.D1(i)*(exp(-2*p.B1(i)*(r(i) - ...
                        p.r10(i))) - exp(-p.B1(i)*(r(i) - p.r10(i))));

        if (r(i) <= p.R_1(i))
            dE3(i,i) = -2*p.B3(i)*p.D3(i)*(exp(-2*p.B3(i)*(r(i) - ...
                        p.r30(i))) + exp(-p.B3(i)*(r(i) - p.r30(i))));
        else
            dE3(i,i) = p.C(i)*exp(-p.Si(i)*r(i))*...
                        (1 - p.Si(i)*(r(i) + p.A(i)));
        endif
    endfor

    dE1(1,2) = 0;
    dE3(1,2) = 0;
    dE1(2,1) = 0;
    dE3(2,1) = 0;

    dE1(3,1) = dE1(3,3);
    dE3(3,1) = dE3(3,3);
    dE1(3,2) = dE1(3,3);
    dE3(3,2) = dE3(3,3);

    dE1(1,3) = 1000;
    dE3(1,3) = 1000;
    dE1(2,3) = 1000;
    dE3(2,3) = 1000;
    dE1(3,3) = 1000;
    dE3(3,3) = 1000;

    for i = 1:3
        for j = 1:3
            dQ(i,j) = (dE1(i,j) + dE3(i,j))/2;
            dJ(i,j) = (dE1(i,j) - dE3(i,j))/2;
        endfor
    endfor

    dV(1) = dQ(1,1) + dQ(3,1) - 0.5/sqrt(0.5*((J(1) - J(2))*(J(1) - J(2)) + ...
              (J(2) - J(3))*(J(2) - J(3)) + (J(1) - J(3))*(J(1) - J(3))))*...
              (J(1)*(2*dJ(1,1) - dJ(3,1)) + J(2)*(-dJ(1,1) - dJ(3,1)) + ...
              J(3)*(2*dJ(3,1) - dJ(1,1)));

    dV(2) = dQ(2,2) + dQ(3,2) - 0.5/sqrt(0.5*((J(1) - J(2))*(J(1) - J(2)) + ...
              (J(2) - J(3))*(J(2) - J(3)) + (J(1) - J(3))*(J(1) - J(3))))*...
              (J(1)*(-dJ(2,2) - dJ(3,2)) + J(2)*(2*dJ(2,2) - dJ(3,2)) + ...
              J(3)*(2*dJ(3,2) - dJ(2,2)));

    retval = dV(1)/dV(2);
endfunction