
%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 8/22/2018

p.D1  = [129.3; 94.8; 129.3];
p.B1  = [2.316; 2.047; 2.316];
p.r10 = [0.931; 0.753; 0.931];
p.D3  = [51.83; 34.56; 51.83];
p.B3  = [2.229; 1.522; 2.229];
p.r30 = [0.931; 0.753; 0.931];
p.R_1 = [1.217; 0.443; 1.217];
p.C   = [1174.9; 388.8; 1174.9];
p.Si  = [3.090; 1.929; 3.090];
p.A   = [1.315; 0.762; 1.315];

an1 = 0;
en1 = 3;

an2 = 0;
en2 = 3;

n1 = 31;
n2 = 31;

step1 = (en1 - an1) / (n1 - 1);
step2 = (en2 - an2) / (n2 - 1);

d3table = zeros(n2, 3*n1);
table = zeros(n1, n2);

idx = [1, 2, 3];

for p1 = 1:n1
    r1 = (p1-1)*step1 + an1;

    for p2 = 1:n2
        r2 = (p2-1)*step2 + an2;
        tmp = Vau(r1, r2, p);
        d3table(p2,idx) = [r1, r2, tmp];
        table(p1,p2) = tmp;
    endfor

    idx = idx + 3;
endfor

[s, V, d3trace, num] = inittrace(en1, en2, p);

[fid, errmsg] = fopen('hfs.dat', 'w');
fprintf(fid, '# [min]\n');

for i = 1:num
    j = i*3 - 2;
    fprintf(fid, '%f %f %f\n', d3trace(j:j+2));
endfor

fprintf(fid, '\n# [surface]\n');

for p2 = 1:n2
    fprintf(fid,'%f %f %f\n', d3table(p2,:));
    fprintf(fid,'\n');
endfor

fclose (fid);