%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

% assoc_isotherm_lin.m ;   fit to linear form of isotherm
% jbr, 2/23/98
%
% Revised 8/22/2018

% assoc_isotherm_lin = load ('assoc_isotherm_lin.rdat');
% Pdata = assoc_isotherm_lin;
Pdata = [100, 1.28;
         150, 1.63;
         200, 1.77;
         250, 1.94;
         300, 2.06;
         400, 2.21];

ndata = size(Pdata, 1);
ngrid = 20;
P = Pdata(:,1);
b = 1e6/(760*82.06*373);
CO = b*P;
CO_ratio = CO./Pdata(:,2);
data = [CO CO_ratio];
%save -ascii assoc_isotherm_lin.xdat data;

%
% Find the best K_CO and c_m values for the isotherm
% Can use linear least squares here instead of npsol

A = [CO ones(ndata,1)];
x = A \ CO_ratio;

c_m = 1./x(1);
K_CO = x(1)/x(2);

CO_grid = linspace(CO(1), CO(ndata), ngrid)';

CO_ratio_opt =  CO_grid./c_m + 1/(K_CO*c_m);

output = [CO_grid CO_ratio_opt];
%save -ascii assoc_isotherm_lin.fit output;
%save -ascii assoc_isotherm_lin.xdat data;

save assoc_isotherm_lin.dat output data

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (output(:,1),output(:,2),data(:,1),data(:,2),'o');
    axis ([3.5,18,2.5,8]);
    %% TITLE
endif %% PLOTTING