%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 7/24/2018


xisosamples = 30;
yisosamples = 30;
x = logspace(-2, 2, xisosamples)';
y = logspace(-2, 3, yisosamples)';

[xx,yy] = meshgrid(x,y);

zz = xx.*sqrt(yy) ./ ( (1 + xx + sqrt(yy)) ).^2 ;

file = fopen ('CO3d.dat', 'w');

for j = 1:yisosamples
    for i = 1:xisosamples
            fprintf (file, '%f %f %f\n', x(i), y(j), zz(j, i));
    endfor

    if (j < yisosamples)
        fprintf (file, '\n');
    endif
endfor

fclose (file);

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    mesh (xx, yy, zz);
    set(gca,'XScale','log')
    set(gca,'YScale','log')
    %% TITLE
endif %% PLOTTING