
%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 8/22/2018

function [s, V, d3trace, num] = inittrace(en1, en2, p)
    R1sar = 1.29781;
    R2sar = 0.80363;
    numr = 30;

    R1r = linspace(R1sar, en1, numr)';

    opts = odeset('AbsTol', sqrt(eps), 'RelTol', sqrt(eps));
    [tsolver, R2r] = ode15s(@(r1, r2) rder(r1, r2, p), R1r, R2sar, opts);

    R1sal = 1.297;
    R2sal = 0.80363;
    numl = 1000;

    R2l = linspace(R2sal, en2, numl)';

    opts  =  odeset('AbsTol', sqrt(eps), 'RelTol', sqrt(eps));
    [tsolver, R1l] = ode15s (@(r2, r1) lder(r2, r1, p), R2l, R1sal, opts);

    R1rn = zeros(numr, 1);
    R2rn = zeros(numr, 1);
    num = numl + numr;

    for i = 1:numr
        R1rn(i) = R1r(numr+1-i);
        R2rn(i) = R2r(numr+1-i);
    endfor

    R1 = [R1rn; R1l];
    R2 = [R2rn; R2l];
    trtable = [R1, R2];

    s = zeros(num, 1);
    V = zeros(num, 1);
    D = zeros(num, 1);

    s(1) = 0;
    V(1) = Vau(R1(1), R2(1), p);
    D(1) = 1;

    for i = 2:num
        D(i) = i;
        s(i) = sqrt((R1(i) - R1(i-1))^2 + (R2(i) - R2(i-1))^2) + s(i-1);
        V(i) = Vau(R1(i), R2(i), p);
    endfor

    pot = [s, V, R1, R2, D];

    for i = 1:num
        j = i*3 - 2;
        d3trace(j) = R1(i);
        d3trace(j+1) = R2(i);
        d3trace(j+2) = V(i);
    endfor

    d3trace = d3trace';

    %% this seems to be unused.
    %% for a = 1:3
    %%   for i = 1:num
    %%    j = i*3-2;
    %%    d3sptrace(a,j) = R1(i)+(a-2)*0.1;
    %%    d3sptrace(a,j+1) = R2(i);
    %%    d3sptrace(a,j+2) = -100+(a-2);
    %%   endfor
    %% endfor
endfunction