
%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 8/22/2018

p = initdata();

an1 = 0;
en1 = 3;

an2 = 0;
en2 = 3;

n1 = 301;
n2 = 301;

step1 = (en1 - an1) / (n1 - 1);
step2 = (en2 - an2) / (n2 - 1);

d3table = zeros(n2, 3*n1);
table = zeros(n1, n2);

idx = [1, 2, 3];

for p1 = 1:n1
    r1 = (p1 - 1)*step1 + an1;

    for p2 = 1:n2
        r2 = (p2 - 1)*step2 + an2;
        tmp = Vau(r1, r2, p);
        d3table(p2,idx) = [r1, r2, tmp];
        table(p1,p2) = tmp;
    endfor

    idx = idx + 3;
endfor

x = d3table(1,1:3:end)';
y = d3table(:,2);
z = d3table(:,3:3:end);

levels = [3000, 1000, 200, -20, -40, -60, -80, ...
         -90.5, -92, -95, -100, -110, -120];

c = contourc(x, y, z, levels);

[fid, errmsg] = fopen('hfc.dat', 'w');
fprintf(fid, '# [contours]\n');

idx = 1;
nel = numel(c);

while (idx <= nel)
    fprintf(fid, '# contour level %f\n', c(idx));
    idx = idx + 1;
    len = c(idx);
    fprintf(fid, '%f %f\n', c(idx+1:idx+2*len));
    fprintf(fid, '\n');
    idx = idx + 2 * len + 1;
end

[s, V, d3trace, num] = inittrace(en1, en2, p);

fprintf(fid, '\n# [min]\n');

for i = 1:num
    j = i*3-2;
    fprintf(fid, '%f %f %f\n', d3trace(j:j+2));
endfor

fclose(fid);