%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%
%
% compute the van Heerden diagram showing heat generation and heat
% removal to explain steady-state multiplicity
% jbr, 4/1/98
% jbr, updated, 12/28/2017
% Revised 8/13/2018
%
% units are kmol, min, kJ, K, m^3
%

p = struct();
p.k_m      = 0.001;
p.T_m      = 298;
p.E        = 8000;
p.c_Af     = 2;
p.C_p      = 4;
p.rho      = 1000;
p.C_ps     = p.rho*p.C_p;
p.T_f      = 298;
p.T_a      = p.T_f;
p.U        = 0;
p.DeltaH_R = -3e5;

thetavec = [30.9, 15, 1.79];
ntheta = length(thetavec);
nTs = 50;
T_vec = linspace(275, 500, nTs)';
k     = p.k_m*exp(-p.E*(1./T_vec - 1/p.T_m));

for i = 1:ntheta
    theta = thetavec(i);
    Qremoval = p.C_ps/theta*(T_vec - p.T_f);
    Qgenerated = k./(1 + k*theta)*p.c_Af*(-p.DeltaH_R);
    table(i) = {[T_vec Qremoval Qgenerated]};
endfor

%save -ascii vanheerden_1.dat table;
save vanheerden.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    for i = 1:ntheta
        figure()
        plot (table{i}(:,1),table{i}(:,2:3));
    endfor
    %% TITLE
endif %% PLOTTING