%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 8/13/2018

%
% multiplicity parameters
%
% units are kmol, min, kJ, K, m^3
%
%
p = struct();
p.k_m      = 0.001;
p.T_m      = 298;
p.E        = 8000;
p.c_Af     = 2;
p.C_p      = 4;
p.rho      = 1000;
p.C_ps     = p.rho*p.C_p;
p.T_f      = 298;
p.T_a      = p.T_f;
p.U        = 0;

function retval = st_st_cA(x, c_A, DeltaH_R, p)
    theta = x(1);
    T     = x(2);
    k     = p.k_m*exp(-p.E*(1/T - 1/p.T_m));
    retval(1) = p.c_Af - (1 + k*theta)*c_A;
    retval(2) = p.U*theta*(p.T_a - T) + p.C_ps*(p.T_f - T) - ...
                    k*theta*c_A*DeltaH_R;
endfunction

nc_As = 500;
c_Avect = linspace(0.995*p.c_Af, .002*p.c_Af, nc_As);
DelHvec = [-3e5, -2e5, -1e5, -0.5e5, 0, 5e4];
nH = length(DelHvec);
table(1:nH) = {zeros(nc_As,4)};

for j = 1: nH;
    DeltaH_R = DelHvec(j);
    tmp_table = zeros(nc_As,4);
    x0 = [1; p.T_f];

    for i = 1: nc_As
        c_A = c_Avect(i);
        opts = optimset ('MaxFunEvals', 2000*numel(x0), ...
                         'MaxIter', 500*numel(x0));
        [x, fval, info] = fsolve( @(x) st_st_cA(x, c_A, DeltaH_R, p), x0, opts);
        theta = x(1);
        T = x(2);
        conv = (p.c_Af - c_A)/p.c_Af;
        tmp_table(i,:) = [theta, T, conv, info];
        x0 = x;
    endfor

    table(j) = {tmp_table};
endfor

save st_st.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    hold on

    for i = 1:nH
        semilogx(table{i}(:,1),table{i}(:,3))
    endfor

    hold off
    axis([1,1e5,0,1]);

    figure()
    hold on

    for i = 1:nH
        semilogx(table{i}(:,1),table{i}(:,2))
    endfor

    hold off
    axis([1,1e5,260,460]);
%% TITLE st_st_T
endif %% PLOTTING