%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%phi = [0.001,0.01,0.1,1,10];
phi = [1];
%Binv   = [10^8];
Binv   = [0, 0.5, 2, 10]; % B = [Inf 2 .5 .1]

small = 1e-6;
npts = 100;
r = linspace(small,3,npts)';
tmp = r;

% vary phi, hold B constant
%
%   for k=1:length(phi)
%     ca = 3 ./r .* sinh( phi(k)*r ) /  ...
%             (sinh(3*phi(k)) + Binv*(phi(k)*cosh(3*phi(k))-1/3*sinh(3*phi(k)) ));
%     tmp = [tmp ca];
%   endfor
%
% vary B, hold phi constant

for k = 1:length(Binv)
    ca = 3./r.*sinh( phi*r )/  ...
         (sinh(3*phi) + Binv(k)*(phi*cosh(3*phi) - 1/3*sinh(3*phi)));
    tmp = [tmp ca];
endfor

save -ascii biotcvsr.dat tmp;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (tmp(:,1), tmp(:,2:length(Binv)+1));
    %% TITLE
endif %% PLOTTING