%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

Binv = [0 0.5 2 10]; % B = [Inf 2 .5 .1]
nphi = 100;
phi = [logspace(-2,2,nphi)]';
tmp = phi;
%%
%% vary 1/B
%%

for k=1:length(Binv)
    eta = 1./phi.*(1./tanh(3*phi) - 1./(3*phi))./ ...
            ( 1 + Binv(k)*(phi./tanh(3*phi) - 1/3) );
    tmp = [tmp eta];
endfor

save -ascii bioteta.dat tmp;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    loglog (tmp(:,1), tmp(:,2:5));
    %% TITLE
endif %% PLOTTING