%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%%
%% compute the actual phi versus eta
%%
Bbig   = 100;
Bsmall = 0.01;
nphi = 100;
phismall = 10^(-2);
phibig = 10^(4);
phi = [logspace(log10(phismall), log10(phibig), nphi)]';

B = Bbig;
etabig = 1./phi.*(1./tanh(3*phi) - 1./(3*phi))./ ...
            ( 1 + (phi./tanh(3*phi) - 1/3)/B );
B = Bsmall;
etasmall = 1./phi.*(1./tanh(3*phi) - 1./(3*phi))./ ...
            ( 1 + (phi./tanh(3*phi) - 1/3)/B );

tmp = [phi  etabig etasmall];

%save -ascii biotasy.dat tmp;
%%
%% compute the various straight line approximations for asymptotic plots
%%

horiz  = [phismall 1;
          sqrt(Bbig) 1];
minus1 = [1 1;
          phibig 1/phibig];
minus2small = [sqrt(Bsmall) 1;
               phibig 1/(phibig*phibig/Bsmall)];
minus2big = [sqrt(Bbig) 1;
             phibig 1/(phibig*phibig/Bbig)];
auxvbl = [horiz minus1 minus2small minus2big];

%save -ascii biotasy_01.dat auxvbl;
save biotasy.dat tmp auxvbl

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    loglog (tmp(:,1), tmp(:,2:3), ...
            auxvbl(:,1), auxvbl(:,2), ...
            auxvbl(:,3), auxvbl(:,4), ...
            auxvbl(:,5), auxvbl(:,6), ...
            auxvbl(:,7), auxvbl(:,8));
    axis(10.^[-2 4 -6 .5])
    %% TITLE
endif %% PLOTTING