%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

phi = [.1 .5 1. 2];
small = 1e-6;
npts = 100;
r = linspace(small,3,npts)';
Csa = 1;
rs = 1;

tmp = r;

for k=1:length(phi)
    Ca = Csa * 3 * rs./r .* sinh(phi(k) * (r/rs)) / sinh(3*phi(k));
    tmp = [tmp Ca];
endfor

save -ascii cvsr1.dat tmp;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (tmp(:,1), tmp(:,2:5));
    %% TITLE
endif %% PLOTTING