%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 8/14/2018

nphi = 50;
phi = [logspace(-2,2,nphi)]';
eta = (1./(tanh(3*phi)) - 1./(3*phi))./phi;

line1 = 1./phi;
phiasy = logspace(-2,log10(2),nphi)';
line2 = ones(nphi,1);
tmp = [phi eta line1 phiasy line2];

save -ascii etasphere.dat tmp;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    loglog(tmp(:,1), tmp(:,2:3), tmp(:,4), tmp(:,5));
    %% TITLE
endif %% PLOTTING