%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

phi = logspace(-2,2,50)';

%%
%%scale to prevent overflow with third argument
%%

%% octave accepts: bessel = besseli (0:1, 2*phi, 1);
%% matlab needs a loop for this
for i = 0:1
  bessel(:,i+1) = besseli(i, 2*phi, 1);
end%for


eta1 = (1./(tanh(3*phi)) - 1./(3*phi))./phi;
eta2 = bessel(:,2)./phi./bessel(:,1);
eta3 = tanh(phi)./phi;

tmp = [phi eta1 eta2 eta3];

save -ascii etasymmetric.dat tmp;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    loglog (tmp(:,1), tmp(:,2:4));
    %% TITLE
endif %% PLOTTING