%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

small = 1e-3;
x = linspace(small,5,501)';
tau = 2;
Ds = [0.002 0.01 0.05 0.2];
%Ds = [.005];

for i = 1:length(Ds)
    D = Ds(i);
    arg = (1 - x/tau)./sqrt(x/tau)/sqrt(4*D);
    P(:,i) = 0.5*(1 - erf(arg));
    %  LevP(:,i) = 0.5*(1 + erf( ((x/tau) - 1)./sqrt(4*D) ));
    p(:,i) = 1/(2*tau*sqrt(pi*4*D)) .* exp(-arg.*arg).*(tau./x + 1)./sqrt(x/tau);
endfor

Ptable = [x P];
ptable = [x p];

save -ascii dispersionpdens.dat ptable;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (ptable(:,1), ptable(:,2:5));
    %% TITLE
endif %% PLOTTING