%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%%
%%
%% 2 A --> B,  r = k c_A^order
%%
%%
%% transient behavior in a dispersed plug flow reactor
%% steady-state profile in a PFR
%% jbr, 10/20/01
%%
%% Revised 8/16/2018

p.k = 1/2;
p.v = 1/2;
p.D = 0.01;
p.caf = 1;
length = 1;
ncolpt = 50;
p.order = 2;
[col.z, col.A, col.B, col.Q] = colloc(ncolpt - 2,'left','right');

function res = pfrcol(x, ncolpt, p, col)
    %% express the diff eq at every collocation point
    first = col.A*x;
    Ra = -2*p.k*(x.^p.order);
    second = col.B*x;
    res = -p.v*first + p.D*second + Ra;
    %% write over the first and last points with the
    %% boundary conditions
    res(1) = p.v*x(1) - p.D*first(1) - p.v*p.caf;
    res(ncolpt) = first(ncolpt);
endfunction

%x0=ones(ncolpt,1);
%[x, fval, info] = fsolve('pfrcol',x0);
%info

function res = pfrtran(t, y, ydot, ncolpt, p, col)
    tmp = pfrcol(y, ncolpt, p, col);
    a = tmp(1);
    b = tmp(ncolpt);
    res = ydot-tmp;
    %%
    %% put bc at ends
    %%
    res(1) = a;
    res(ncolpt) = b;
endfunction

tsteps = linspace(0, 2.5, 11);
%% initial condition, zero conc. in tube
y0 = zeros(ncolpt, 1);
ydot0 = zeros(ncolpt, 1);
[tout, y] = ode15i(@(t, y, ydot) pfrtran(t, y, ydot, ncolpt, p, col),...
                        tsteps, y0, ydot0);

table = [col.z y'];

save -ascii dispersedpfrtran.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (table(:,1), table(:,2:12));
    %% TITLE
endif %% PLOTTING