%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.
%%
%% Revised 8/16/2018

a = 5;
b = 0.05;

% c0 = 5;
% conv = 0.95;
% d  = sqrt((1-2*b)*(1-2*b) - 4*b*(b+1));
% w1 = (1-2*b + d)/(2*b);
% w2 = (1-2*b - d)/(2*b);
% x1  = sqrt(w1/a);
% x2  = sqrt(w2/a);

function retval = rate(c, a, b)
    rate = c./(1 + a*c.*c) + b*c;
    retval = rate;
endfunction

c = linspace(0.01,10,300)';
y = rate(c, a, b);
table = [c y];

save -ascii leven_rate.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (table(:,1), table(:,2));
    %% TITLE
endif %% PLOTTING