%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

x = linspace(0,5,200)';
tau = 2;
ns = [1 2 3 5 10 25 100];

for i = 1:length(ns)
    n = ns(i);
    P(:,i) = gammainc(n/tau*x,n);
    % p(:,i) = n^n/gamma(n)*x.^(n-1)/tau^n.*exp(-n*x/tau);
    logp = -gammaln(n) + n*log(n/tau) + (n-1)*log(x) - n*x/tau;
    p(:,i) = exp(logp);
endfor

ptable = [x p];
Ptable = [x P];

#save -ascii ncstrspdens.dat ptable;
save ncstrspdens.dat ptable;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (ptable(:,1), ptable(:,2:end));
    %% TITLE
endif %% PLOTTING