%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%
% arhenius.m
%
chisq = 5.99;  % chi square value for 95% confidence level with 2 parameters
lnk0  = 1;
E     = 100;
ndata = 10;
Tmin  = 300;
Tmax  = 500;
Tmeas = linspace(Tmin,Tmax,ndata)';
X     = [ones(ndata,1) -1./Tmeas];
lnk   = X*[lnk0; E];
k     = exp(lnk);
measvar= 1e-3;
measstddev = sqrt(measvar);

% set seed for "reproducible" random numbers
randn('seed',0);

%some noisy data points
nexpts = 500;
clear lnkmeas;

for i = 1:nexpts
    lnkmeas(:,i) = lnk + measstddev*randn(ndata,1);
endfor

theta = (inv(X'*X)*X' * lnkmeas)';

Tcenter = -1./Tmeas + 1/mean(Tmeas);
Xcenter = [ones(ndata,1) Tcenter];
thetacenter = (inv(Xcenter'*Xcenter)*Xcenter' * lnkmeas)';

%% calculate the elliptical confidence interval and bounding box
npts = 181;
amat = X'*X/measvar;
level = chisq;
[x, y, major, minor, bbox] = ellipse (amat, level, npts);
x = x + lnk0;
y = y + E;

minor(:,1) = minor(:,1) + lnk0;
minor(:,2) = minor(:,2) + E;
major(:,1) = major(:,1) + lnk0;
major(:,2) = major(:,2) + E;
bbox(:,1) = bbox(:,1) + lnk0;
bbox(:,2) = bbox(:,2) + E;

elips = [x, y];

save arrhenius.dat theta bbox elips;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (theta(:,1), theta(:,2), '+', bbox(:,1), bbox(:,2), ...
           elips(:,1), elips(:,2));
    %% TITLE
endif %% PLOTTING