%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

p     = [2; 5];
alpha = 0.95;
nplot = 100;
large = 50;

for i = 1:length(p);

    min = p(i) + 1;
    ndata = linspace(min, large, nplot)';
    chisq = chi2inv(alpha, p(i))*ones(nplot, 1);
    Fstat = p(i)*finv(alpha, p(i), ndata - p(i));
    index = (i - 1)*3 + 1;
    table(:,index:index+2) = [ndata Fstat chisq];

endfor

save -ascii chiF.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (table(:,1), table(:,2), table(:,1), table(:,3), ...
           table(:,4), table(:,5), table(:,4), table(:,6));
    axis ([0, 50, 4, 20]);
    %% TITLE
endif %% PLOTTING