%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%
% arhenius.m
%
alpha = 0.95;
p     = 2;
ndata = 10;
%%chisq = 5.99; % chi square value for 95% confidence level with 2 parameters
%%Fstat = 4.46; % F statistic for 95 % confidence level with 2 parameters and
                % 10 data points (or 10-2=8 degrees of freedcom)

chisq = chi2inv(alpha,p);
Fstat = finv(alpha, p, ndata - p);
lnk0  = 1;
E     = 100;
Tmin  = 300;
Tmax  = 500;
Tmeas = linspace(Tmin, Tmax, ndata)';
X     = [ones(ndata, 1) -1./Tmeas];
lnk   = X*[lnk0; E];
k     = exp(lnk);
measvar = 1e-3;
measstddev = sqrt(measvar);
%
% set seed for 'reproducible' random numbers
%
randn('seed',0);
%
%just a few noisy points
%
nexpts = 1;
clear lnkmeas;

for i = 1:nexpts
    lnkmeas(:,i) = lnk + measstddev*randn(ndata,1);
endfor

%%
%%center the data first
%%
Tcenter = -1./Tmeas + 1/mean(Tmeas);
Xcenter = [ones(ndata,1) Tcenter];
thetacenter = inv(Xcenter'*Xcenter)*Xcenter' * lnkmeas;
data = [1./Tmeas, lnkmeas(:,1)];
% save -ascii parestonedata.xdat data;

nplot = 20;
Tplot = linspace(Tmin,Tmax,nplot)';
Xplot = [ones(nplot,1) -1./Tplot + 1/mean(Tmeas)];
lnkfit= Xplot*thetacenter;
residual = lnkmeas - Xcenter*thetacenter;
fit   = [1./Tplot, lnkfit];
% save -ascii parestonedata.fit fit;

save parestonedata.dat fit data;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (fit(:,1), fit(:,2), data(:,1), data(:,2), '+');
    %% TITLE
endif %% PLOTTING