%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

chisq = 5.99;  % chi square value for 95% confidence level with 2 parameters
lnk0  = 1;
E     = 100;
Tmin  = 300;
Tmax  = 500;
nTvals = 51;
n0 = 1;
T0 = [ones(n0,1)*Tmin; ones(n0,1)*Tmax];
%T0 = linspace(Tmin,Tmax,2*n0)';
S = eye(2);
Trep  = 1./linspace(1/Tmin,1/Tmax,nTvals)';
meanT = 1/(0.5*(1/Tmin+1/Tmax));
Trep_len = length(Trep);
intun = zeros(Trep_len,1);
vol = zeros(Trep_len,1);
vbox = zeros(Trep_len,1);
slopeun = zeros(Trep_len,1);

for i = 1:Trep_len
    Tmeas = [T0; Trep(i)];
    ndata = size(Tmeas,1);
    Tcenter = -1./Tmeas + 1/meanT;
    X = [ones(ndata,1) Tcenter];
    % X = [ones(ndata,1), -1./Tmeas];
    measvar = 1e-3;
    measstddev = sqrt(measvar);
    amat = S*X'*X*S/measvar;
    level = chisq;
    %%
    %% volume of 95% confidence ellipse and bounding box
    %%
    inva = inv(amat);
    intun(i) = sqrt(level*inva(1,1));
    slopeun(i) = sqrt(level*inva(2,2));
    vol(i) = pi*level/(sqrt(det(amat)));
    vbox(i) = 4*level*sqrt(prod(diag(inva)));
endfor

%plot(Trep,[intun slopeun])

table = [Trep intun slopeun];
save -ascii nextTb.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    subplot (2, 1, 1);
    plot (table(:,1), table(:,2));
    %% TITLE nextTb

    subplot (2, 1, 2);
    plot (table(:,1), table(:,3));
    %% TITLE nextTb
endif %% PLOTTING