%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

alpha = 0.95;
p     = 2;
chisq = chi2inv(alpha, p);
lnk0  = 1;
E     = 100;
Tmin  = 300;
Tmax  = 500;
nTvals = 10;
n0 = 1;
Tmeas = linspace(Tmin, Tmax, nTvals)';
S = eye(2);
%meanT = 1/(0.5*(1/Tmin+1/Tmax));
meanT = mean(Tmeas);
sets = [1; 2; 5; 100];
nsets = length(sets);
measvar = 1e-3;
measstddev = sqrt(measvar);

for i = 1:nsets
    %%
    %% stack Tmeas on top of itself sets(i) times
    %%
    Tmeasset = kron(ones(sets(i),1), Tmeas);
    ndata = size(Tmeasset,1);
    Tcenter = -1./Tmeasset + 1/meanT;
    X = [ones(ndata,1) Tcenter];
    amat = S*X'*X*S/measvar;
    level = chisq;
    %%
    %% 95% confidence ellipse
    %%
    [x, y] = ellipse (amat, level, 150);
    idx = (i-1)*2+1;
    table(:,idx:idx+1) = [x y];

endfor

save -ascii replicate.dat table;

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    plot (table(:,1), table(:,2), ...
          table(:,3), table(:,4), ...
          table(:,5), table(:,6), ...
          table(:,7), table(:,8));
    %% TITLE
endif %% PLOTTING