%%
%% jbr,  4/8/18
%%


model = struct;
%model.nlpg_solver_options.ipopt.linear_solver = 'ma27';
model.x = {'ca'};
model.p = {'k', 'n'};
model.d = {'m_ca'};
model.transcription = 'shooting';

model.ode = @(t, y, p) {-p.k * y.ca^p.n};

model.lsq = @(t, y, p) {y.ca - y.m_ca};

tfinal = 5;
nts    = 100;
tout = linspace(0,tfinal,nts);
model.tout = tout;

pe = paresto(model);

kac   = 0.5;
nac   = 2.5;
ca0ac = 2;
thetaac = [kac; nac; ca0ac];

x_ac = ca0ac;
p_ac = [kac; nac];

y_ac = pe.simulate(0, x_ac, p_ac);

%% add measurement noise
measvar = 1e-2;
measstddev = sqrt(measvar);
randn('seed',0);
noise = measstddev*randn(1,nts);

y_noisy = y_ac + noise;


% Initial guess, upper and lower bounds for the estimated parameters
small = 1e-3;
large  = 5;
np = 3;

theta0 = struct();
theta0.k = kac;
theta0.n = nac;
theta0.ca = ca0ac;

ubtheta = struct();
ubtheta.k = large;
ubtheta.n = large;
ubtheta.ca = large;

lbtheta = struct();
lbtheta.k = small;
lbtheta.n = small;
lbtheta.ca = small;

## % Initial guess, upper and lower bounds for the estimated parameters
## theta0 = [0.5; 2.5; 2];
## lbtheta = 0.5*[p_ac; x_ac(:)];
## ubtheta = 1.5*[p_ac; x_ac(:)];

% Estimate parameters
[est, y, p] = pe.optimize(y_noisy, theta0, lbtheta, ubtheta);
est.d2f_dtheta2;

% Also calculate confidence intervals with 95 % confidence

theta_conf = pe.confidence(est, 0.95);

conf = pe.confidence(est,  0.95);

disp('Estimated parameters')
disp(est.thetavec)
disp(est.theta)
disp('Bounding box intervals')
disp(conf.bbox)

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
% Plot simulated measurement values
plot(tout, y_noisy, 'ro', tout, y.ca)
%% TITLE
endif %% PLOTTING

table  = [tout; y_noisy; y.ca; y_ac]';
save nthorder.dat table;