
%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%% Made this m file in the second printing to get a proper staircase
%% plot of the flowrate versus time
%% jbr, 12/27/03
%%

% This m-file loads data file 'lc.dat'.
% This m-file loads data file 'flow.dat'.
vro       = 2370;
teaf      = 0.00721;
teaden    = 0.728;
flow = load('flow.dat');
lc = load('lc.dat');
tflow  = [0. ; flow(:,1)];
flowrate = [0. ; flow(:,2)./teaden];
tlc    = lc(:,1);
lcmeas = lc(:,2);

[tflows, flowrates] = stairs (tflow, flowrate);

data = struct();
data.flow = [tflows, flowrates];
data.lc = lc;

gnuplotsave('flowlc.dat', data);

if (~ strcmp (getenv ('OMIT_PLOTS'), 'true')) %% PLOTTING
    subplot(2,1,1);
    plot (tflows, flowrates);
    %% TITLE flowlc

    subplot(2,1,2);
    plot (tlc, lcmeas, '+');
    %% TITLE flowlc
endif %% PLOTTING