%% Copyright (C) 2001, James B. Rawlings and John G. Ekerdt
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; see the file COPYING.  If not, write to
%% the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
%% MA 02111-1307, USA.

%% Assumes T is sorted and contains no duplicate values.

function [index, is_switching_time] = find_time_index (t, now)

    if (nargin ~= 2)
        error ('usage: [index, is_switching_time] = find_time_index (t, now)');
    endif

    if (~ isvector (t) || ~ isscalar (now))
        error ('find_time_index: T must be a vector and NOW must be a scalar');
    endif

    %% use last flowrate past final time
    if (now < t(1))
        error ('find_time_index: NOW = %f is out of range [%f, %f]', ...
               now, t(1), t(end));
    endif

    if (now > t(end))
        index = length(t);
    else
        index = max (find (t <= now));
    endif

    is_switching_time = (t(index) == now);

endfunction